/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.aural;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.aural.ACssProperties;
import org.w3c.css.properties.aural.ACssProperty;
import org.w3c.css.properties.aural.ACssStyle;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssAngle;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssValue;

public class ACssAzimuth
extends ACssProperty {
    CssValue value = defaultIdentValue;
    boolean isBehind;
    private static int[] hash_values;
    private static String[] AZIMUTH;
    private static CssIdent defaultIdentValue;
    private static CssIdent behind;
    private static CssIdent leftwards;
    private static CssIdent rightwards;

    public ACssAzimuth() {
    }

    public ACssAzimuth(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        this();
        if (check2 && expression.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        this.setByUser();
        if (val.equals(leftwards)) {
            if (check2 && expression.getCount() > 1) {
                throw new InvalidParamException("unrecognize", ac);
            }
            this.value = leftwards;
            expression.next();
            return;
        }
        if (val.equals(inherit)) {
            if (expression.getCount() > 1) {
                throw new InvalidParamException("unrecognize", ac);
            }
            this.value = inherit;
            expression.next();
            return;
        }
        if (val.equals(rightwards)) {
            if (check2 && expression.getCount() > 1) {
                throw new InvalidParamException("unrecognize", ac);
            }
            this.value = rightwards;
            expression.next();
            return;
        }
        if (val.equals(behind)) {
            this.isBehind = true;
            expression.next();
            CssValue valnext = expression.getValue();
            if (valnext == null) {
                this.value = null;
                return;
            }
            if (valnext instanceof CssIdent) {
                this.value = this.checkIdent(ac, (CssIdent)valnext);
                expression.next();
                return;
            }
        } else if (val instanceof CssIdent) {
            expression.next();
            CssValue valnext = expression.getValue();
            if (valnext == null) {
                this.value = this.checkIdent(ac, (CssIdent)val);
                return;
            }
            if (valnext.equals(behind)) {
                this.value = this.checkIdent(ac, (CssIdent)val);
                this.isBehind = true;
                expression.next();
                return;
            }
        } else {
            if (val instanceof CssAngle) {
                if (check2 && expression.getCount() > 1) {
                    throw new InvalidParamException("unrecognize", ac);
                }
                CssAngle angle = (CssAngle)val;
                if (!angle.isDegree()) {
                    throw new InvalidParamException("degree", null, ac);
                }
                this.value = val;
                expression.next();
                return;
            }
            if (val instanceof CssNumber) {
                if (check2 && expression.getCount() > 1) {
                    throw new InvalidParamException("unrecognize", ac);
                }
                this.value = ((CssNumber)val).getAngle();
                expression.next();
                return;
            }
        }
        throw new InvalidParamException("value", expression.getValue().toString(), this.getPropertyName(), ac);
    }

    public ACssAzimuth(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public Object get() {
        return this.value;
    }

    public String getPropertyName() {
        return "azimuth";
    }

    public boolean isSoftlyInherited() {
        return this.value.equals(inherit);
    }

    public String toString() {
        if (this.isBehind) {
            if (this.value != null) {
                return behind.toString() + " " + this.value.toString();
            }
            return behind.toString();
        }
        return this.value.toString();
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        if (((ACssStyle)style).acssAzimuth != null) {
            style.addRedefinitionWarning(ac, this);
        }
        ((ACssStyle)style).acssAzimuth = this;
    }

    public boolean equals(CssProperty property) {
        return property instanceof ACssAzimuth && this.value.equals(((ACssAzimuth)property).value);
    }

    private CssIdent checkIdent(ApplContext ac, CssIdent ident) throws InvalidParamException {
        int hash = ident.hashCode();
        for (int i = 0; i < AZIMUTH.length; ++i) {
            if (hash_values[i] != hash) continue;
            return ident;
        }
        throw new InvalidParamException("value", ident.toString(), this.getPropertyName(), ac);
    }

    private Float ValueOfIdent(ApplContext ac, CssIdent ident, boolean b) throws InvalidParamException {
        int hash = ident.hashCode();
        for (int i = 0; i < AZIMUTH.length; ++i) {
            if (hash_values[i] != hash) continue;
            if (b) {
                return ACssProperties.getValue(this, behind.toString() + "." + AZIMUTH[i]);
            }
            return ACssProperties.getValue(this, AZIMUTH[i]);
        }
        throw new InvalidParamException("value", ident.toString(), this.getPropertyName(), ac);
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((ACssStyle)style).getAzimuth();
        }
        return ((ACssStyle)style).acssAzimuth;
    }

    static {
        AZIMUTH = new String[]{"left-side", "far-left", "left", "center-left", "center", "center-right", "right", "far-right", "right-side"};
        defaultIdentValue = new CssIdent(AZIMUTH[4]);
        behind = new CssIdent("behind");
        leftwards = new CssIdent("leftwards");
        rightwards = new CssIdent("rightwards");
        hash_values = new int[AZIMUTH.length];
        for (int i = 0; i < AZIMUTH.length; ++i) {
            ACssAzimuth.hash_values[i] = AZIMUTH[i].hashCode();
        }
    }
}

